CREATE OR REPLACE FUNCTION addColumn()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns     
                    WHERE table_name= 'est_orc_cpl' 
                         and column_name='dt_emi_it') THEN
                         
        RAISE NOTICE 'Coluna "dt_emi_it" na tabela "est_orc_cpl" ja existe!' ;
        
    ELSE
        ALTER TABLE public.est_orc_cpl   ADD COLUMN dt_emi_it timestamp without time zone;     
        RAISE NOTICE 'Coluna "dt_emi_it" criada com sucesso!';
    END IF; 
    
END;
-- fim bloco principal
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION addColumn()  OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();